/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.block.entity;

import com.ferreusveritas.dynamictrees.api.TreeRegistry;
import com.ferreusveritas.dynamictrees.init.DTRegistries;
import com.ferreusveritas.dynamictrees.tree.species.Species;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FlowerPotBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.model.data.ModelData;
import net.minecraftforge.client.model.data.ModelProperty;
import net.minecraftforge.registries.ForgeRegistries;

public class PottedSaplingBlockEntity
extends BlockEntity {
    private static final String POT_MIMIC_TAG = "pot_mimic";
    private static final String SPECIES_TAG = "species";
    public static final ModelProperty<BlockState> POT_MIMIC = new ModelProperty();
    public static final ModelProperty<Species> SPECIES = new ModelProperty();
    private BlockState potState = Blocks.f_50276_.m_49966_();
    private Species species = Species.NULL_SPECIES;

    public PottedSaplingBlockEntity(BlockPos pos, BlockState state) {
        super(DTRegistries.POTTED_SAPLING_BLOCK_ENTITY, pos, state);
    }

    public Species getSpecies() {
        return this.species;
    }

    public void setSpecies(Species species) {
        this.species = species;
        this.m_6596_();
        this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
    }

    public BlockState getPot() {
        return this.potState;
    }

    public void setPot(BlockState newPotState) {
        this.potState = newPotState.m_60734_() instanceof FlowerPotBlock ? newPotState.m_60734_().m_49966_() : Blocks.f_50276_.m_49966_();
        this.m_6596_();
        this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
    }

    public CompoundTag m_5995_() {
        CompoundTag tag = super.m_5995_();
        this.m_183515_(tag);
        return tag;
    }

    @Nullable
    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public void onDataPacket(Connection connection, ClientboundBlockEntityDataPacket packet) {
        BlockState oldPotState = this.potState;
        this.handleUpdateTag(packet.m_131708_());
        if (!oldPotState.equals(this.potState)) {
            this.f_58857_.getModelDataManager().requestRefresh((BlockEntity)this);
            this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
        }
    }

    public void m_142466_(CompoundTag tag) {
        if (tag.m_128441_(POT_MIMIC_TAG)) {
            Block block = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(tag.m_128461_(POT_MIMIC_TAG)));
            BlockState blockState = this.potState = block != Blocks.f_50016_ ? block.m_49966_() : Blocks.f_50276_.m_49966_();
        }
        if (tag.m_128441_(SPECIES_TAG)) {
            this.species = TreeRegistry.findSpecies(tag.m_128461_(SPECIES_TAG));
        }
        super.m_142466_(tag);
    }

    protected void m_183515_(CompoundTag tag) {
        tag.m_128359_(POT_MIMIC_TAG, ForgeRegistries.BLOCKS.getKey((Object)this.potState.m_60734_()).toString());
        tag.m_128359_(SPECIES_TAG, this.species.getRegistryName().toString());
    }

    @Nonnull
    public ModelData getModelData() {
        return ModelData.builder().with(POT_MIMIC, (Object)this.potState).with(SPECIES, (Object)this.species).build();
    }
}

